//
CUpdate	= OOP_Derive( CDatabase );

//
function CUpdate:__ctor( )
	// version table doesn't exist?
	if( !self:TableExists( "vmfsuite_app" ) ) then
		// create and insert the vmf-suite app keyvalue field.
		self:Query(
			"CREATE TABLE IF NOT EXISTS vmfsuite_app ( key VARCHAR(255), value VARCHAR(32) );"
		);
		
		//
		self:Query(
			"INSERT INTO vmfsuite_app ( key, value ) VALUES( 'version', '" .. VMFSuite.Version .. "' );"
		);
		
		// drop tables
		self:DropTables();
		
		//
		print( "VMF-Suite Initial Run.." );
	
	end
	
	// version is different?
	local results = self:Query( "SELECT value FROM vmfsuite_app WHERE key = 'version'" );
	if( results && tonumber( results[1].value ) != VMFSuite.Version ) then
		// drop tables
		self:DropTables();
		
		// update version
		self:Query(
			"UPDATE vmfsuite_app SET value = '" .. VMFSuite.Version .. "' WHERE key = 'version';"
		);
		
		//
		print( "VMF-Suite New Version.." );
	
	end
	
end

// drop tables
function CUpdate:DropTables( )
	//
	print( "Dropping VMF-Suite tables.. " );

	// drop the vmf-suite tables.
	self:Query( "DROP TABLE vmfsuite_flags;" );
	self:Query( "DROP TABLE vmfsuite_admins;" );
	self:Query( "DROP TABLE vmfsuite_vmfinfo;" );
	self:Query( "DROP TABLE vmfsuite_clientvmfs;" );

end

//
VMFSuite.Updater = CUpdate:create();

